/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class SimpleCookingSerializer<T extends AbstractCookingRecipe>
implements RecipeSerializer<T> {
    private final AbstractCookingRecipe.Factory<T> factory;
    private final MapCodec<T> codec;
    private final StreamCodec<RegistryFriendlyByteBuf, T> streamCodec;

    public SimpleCookingSerializer(AbstractCookingRecipe.Factory<T> p_312065_, int p_44331_) {
        this.factory = p_312065_;
        this.codec = RecordCodecBuilder.mapCodec(p_300831_ -> p_300831_.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(p_300832_ -> p_300832_.group), (App)CookingBookCategory.CODEC.fieldOf("category").orElse((Object)CookingBookCategory.MISC).forGetter(p_300828_ -> p_300828_.category), (App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(p_300833_ -> p_300833_.ingredient), (App)ItemStack.STRICT_SINGLE_ITEM_CODEC.fieldOf("result").forGetter(p_300827_ -> p_300827_.result), (App)Codec.FLOAT.fieldOf("experience").orElse((Object)Float.valueOf(0.0f)).forGetter(p_300826_ -> Float.valueOf(p_300826_.experience)), (App)Codec.INT.fieldOf("cookingtime").orElse((Object)p_44331_).forGetter(p_300834_ -> p_300834_.cookingTime)).apply((Applicative)p_300831_, p_312065_::create));
        this.streamCodec = StreamCodec.of(this::toNetwork, this::fromNetwork);
    }

    @Override
    public MapCodec<T> codec() {
        return this.codec;
    }

    @Override
    public StreamCodec<RegistryFriendlyByteBuf, T> streamCodec() {
        return this.streamCodec;
    }

    private T fromNetwork(RegistryFriendlyByteBuf p_320282_) {
        String $$1 = p_320282_.readUtf();
        CookingBookCategory $$2 = p_320282_.readEnum(CookingBookCategory.class);
        Ingredient $$3 = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode(p_320282_);
        ItemStack $$4 = (ItemStack)ItemStack.STREAM_CODEC.decode(p_320282_);
        float $$5 = p_320282_.readFloat();
        int $$6 = p_320282_.readVarInt();
        return this.factory.create($$1, $$2, $$3, $$4, $$5, $$6);
    }

    private void toNetwork(RegistryFriendlyByteBuf p_320422_, T p_320933_) {
        p_320422_.writeUtf(((AbstractCookingRecipe)p_320933_).group);
        p_320422_.writeEnum(((AbstractCookingRecipe)p_320933_).category());
        Ingredient.CONTENTS_STREAM_CODEC.encode(p_320422_, ((AbstractCookingRecipe)p_320933_).ingredient);
        ItemStack.STREAM_CODEC.encode(p_320422_, ((AbstractCookingRecipe)p_320933_).result);
        p_320422_.writeFloat(((AbstractCookingRecipe)p_320933_).experience);
        p_320422_.writeVarInt(((AbstractCookingRecipe)p_320933_).cookingTime);
    }

    public AbstractCookingRecipe create(String p_312671_, CookingBookCategory p_312067_, Ingredient p_312327_, ItemStack p_311758_, float p_312386_, int p_311986_) {
        return this.factory.create(p_312671_, p_312067_, p_312327_, p_311758_, p_312386_, p_311986_);
    }
}

